﻿
function customCallbackClass() {

    var m_customCallback = this;
    m_customCallback.m_CloseSentinel = null;
    m_customCallback.m_Config = null;
    m_customCallback.m_CallInfo = null;
    m_customCallback.m_InterviewerFrame = null;
    m_customCallback.m_EventPublisher = null;
    m_customCallback.m_bCallbackInProcess   = false;
    m_customCallback.m_bOnCall              = false;
    m_customCallback.m_ExternalNotifier     = null;
    m_customCallback.m_callbacktag = null;
    m_customCallback.m_bLogeEnable = false ;
    m_customCallback.m_BaseUrl = "";
    m_customCallback.m_PublishUserData = {};

    this.createUserData = function (userid) {

        var userdata = {};

        if (m_customCallback.m_PublishUserData == undefined) {
            userdata.recordid   = "";
            userdata.projectid  = "";
            userdata.state      = "";
            userdata.errorcode  = 0;
            userdata.errormsg   = "" ;
            return userdata;
        }

        if (m_customCallback.m_PublishUserData.userid == undefined || m_customCallback.m_PublishUserData.userid == 0)
            m_customCallback.m_PublishUserData.userid = m_customCallback.m_Config.getUserId();



        //
        // Nous ne sommes pas entrain d'executer un callback donc allons chercher les recno de voxco.agent
        //

        userdata.recordid = m_customCallback.m_PublishUserData.recordid;
        if( m_customCallback.m_bCallbackInProcess == false ) {
            userdata.recordid = m_customCallback.m_CallInfo.Get( "recordid" ) ;
        }

        userdata.userid     = m_customCallback.m_PublishUserData.userid;
        userdata.projectid  = m_customCallback.m_PublishUserData.projectid;
        userdata.state      = m_customCallback.m_PublishUserData.state;
        return userdata;
    }


    //
    //  Optionnal ..
    //
    //  This method is called by the external application if it needs to be notify with:
    //
    //      oncall          -> agent connected with respondent 
    //      ondial          -> agent is currently dialing 
    //      oncomplete      -> the interview is done 
    //      onstatechange   -> agent state change ( Idle , connected ,wrap up , dialing  etc )
    //
    //
    //  Before calling the methode subscribes , the external application must call getCallbackObject() to make sure that all properties is correctly set for internal usage
    //  Because we share information with an external application it is important that naming properties is constant between application
    //
    //
    //  userfunctions  -> contains the callback notification function for the oncall , ondial... Must be created with getCallbackObject()
    //  
    //


   
    
    this.Subscribe = function (userfunctions) {

        m_customCallback.log("customCallbackClass.Subscribe> An external application has subscribed to voxco.agent events...", false );
        m_customCallback.m_ExternalNotifier = userfunctions ;
        return;
    }


    //
    // To make sure that the callback is correctly set,  this method 
    // returns a callback object with the correct property name.
    //
    //  Need to call subscribes method if the extern application need to be notify for 
    //
    //  oncall          event   ( The agent is connected with a respondent
    //  onstatechange   event   ( Idle , Wrap Up , connected ... )
    //  ondial          event   ( The agent is dialing )
    //  oncomplete      event   ( The interview is done )
    //
    //

    this.getCallbackObject = function (oncall, onstatechange, ondial, oncomplete, oninterview, onerror) {

        m_customCallback.log("customCallbackClass.getCallbackObject> Creating voxco.agent callback object...", false );
        return new m_customCallback.m_CloseSentinel.callbackobject(oncall, onstatechange, ondial, oncomplete, oninterview,onerror );
    }


    //
    //  Object class initialization . Callled when the external application create the object class by calling createCustomCallback()
    //
    //  m_customCallback.m_callbacktag contain all the callback tag that needs to be shared. As an example 
    //  m_callbacktag.ondial contains the string idenfier for the ondial callback method

    //  m_customCallback.getCallbackObject  -> create the callback object for internal use. 
    //
    //                                         ondial           ... called by voxco.agent when the agent is dialing 
    //                                         oncall           ... called by voxco.agent when the agent is connected with the end user
    //                                         onstatechange    ... called by voxco.agent when the state of the agent changes
    //                                         omcomplete       ... called by voxco.agent when the interview is done
    //
    //  m_customCallback.m_BaseUrl          -> contains the base url to contact the intweb server
    //
    // 
    //  
    //
    this.Init = function () {
        

        m_customCallback.m_CloseSentinel = gClassManager.getCloseSentinelFrame();
        m_customCallback.m_Config = gClassManager.getConfigManager();
        m_customCallback.m_CallInfo = gClassManager.getCallClass();
        m_customCallback.m_InterviewerFrame = gClassManager.getSharedFrame();
        m_customCallback.m_EventPublisher = gClassManager.getEventPublisher();

        m_customCallback.m_callbacktag = new m_customCallback.m_CloseSentinel.callbacktag();

        var callback = m_customCallback.getCallbackObject(m_customCallback.onCall, m_customCallback.onStateChange, m_customCallback.onDial, m_customCallback.onInterviewComplete, m_customCallback.onInterview, m_customCallback.onError);
        callback.onprojectselection = m_customCallback.onProjectSelection;

        m_customCallback.m_EventPublisher.subscribe( callback ) ;

        var href = $(window.location).attr('href').toLowerCase();
        var baseurlpos = href.indexOf("voxco");

       
        m_customCallback.m_PublishUserData = m_customCallback.createUserData(m_customCallback.m_Config.getUserId());
        m_customCallback.m_BaseUrl = href.substr(0, baseurlpos);
        m_customCallback.m_BaseUrl += 'survey/intweb.dll';


        m_customCallback.ResetInternalData();
        return;
    }

    //
    //  This method will create the intweb request to execute the callback 
    //
    //
    //  Return 
    //
    //  Result.errormsg   if the function fails errormsg will contain a description of the error
    //  Result.success     true | false ... false will be considered as an error 
    //
    //
    //  Restriction :
    //
    //  The call back will be only execute in preview project only
    //

    this.executeCallback = function (projectid, recordid) {

        var Result = { success:true , errormsg:"" };

        if (m_customCallback.m_bCallbackInProcess == true) {

            m_customCallback.log("customCallbackClass.executeCallback> Not able to excecute call back id " + recordid + "  on project id  " + projectid + ". A callback is already in process", true);
            Result.errormsg = "failed to execute the callback record " + recordid + " on project id " + projectid + ". Already have a call back in process";
            Result.success = false;
            return Result;
        }

        if (_MODULE_PREVIEW != m_customCallback.m_Config.getProjectType()) {

            m_customCallback.log("customCallbackClass.executeCallback> Not able to excecute call back id " + recordid + "  on project id  " + projectid + ". The callback external tool is only supported on preview project" ,  true);
            Result.errormsg = "external call back execution is not supported with that project type " + m_customCallback.m_Config.getProjectType() + "." + "Only preview project is supported";
            Result.success = false;
            return Result;
        }
   
        if (m_customCallback.m_bOnCall == true) {
            m_customCallback.log("customCallbackClass.executeCallback> Not able to excecute call back id " + recordid + "  on project id  " + projectid + ". The agent is already doing interview", true);
            Result.errormsg = "external call cannot be execute because the agent is already doing interview";
            Result.success = false;
            return Result;
        }

   
        //
        // Create a volatile interview..
        //

        m_customCallback.m_PublishUserData.projectid    = projectid;
        m_customCallback.m_PublishUserData.recordid     = recordid;

        var guid        = AgentAssignment.getSessionGuid();
        var url         = m_customCallback.m_BaseUrl + '?IACTION=19&INTMODE=1&IMODE=3&FAILIFINUSE=1' + '&CALLBACKID=' + recordid + "&PROJECT=" + projectid + "&sessionguid=" + guid ;


        m_customCallback.log("customCallbackClass.executeCallback> Executing callback id " + recordid + " on project id " + projectid, false);
        m_customCallback.log("customCallbackClass.executeCallback> The request sent to intweb :  " + url, false );
        
        setTimeout("setIntWebUrl('" + url + "');", 1);

        m_customCallback.m_bCallbackInProcess = true;
        return Result;
    }

    
    //
    //  This could be use to insert inner html code to present the callback table for the agent to benefit to larger area
    //
    //  When the agent selects a callback , it should call one to your internal function  to execute executeCallback( projectid, recordid )  methode
    //
    this.insertHtmlCallback = function (innerdocument, elementid) {

        var myCallbackDiv = m_customCallback.m_InterviewerFrame.document.createElement("div");

        myCallbackDiv.style.visibility = 'visible';
        myCallbackDiv.id = elementid;
        myCallbackDiv.appendChild(myCallbackDiv);
        return;
    }

    //
    //  This method is called by voxco.agent when the agent state changed. When received, if the external application 
    //  subscribes to onstatechange  event , it will be forwarded with m_customCallback.forward() method
    //  
    //
    //  If the external application is interested to it , it needs to call those methods 
    //
    //      1) getCallbackObject()
    //      2) subscribe() 
    //

    this.onStateChange = function (userdata) {

        m_customCallback.log("customCallbackClass.onStateChange> State of the agent has changed to " + userdata + " ...", false );

        m_customCallback.m_PublishUserData.state = userdata;
        var publishdata = m_customCallback.createUserData();

        m_customCallback.forward(m_customCallback.m_callbacktag.onstatechange, publishdata);
    }


    this.onError = function (userdata) {

        try {

            var publishdata = m_customCallback.createUserData();

            publishdata.errorcode = userdata.errorcode;
            publishdata.errormsg = userdata.errormsg;

            if( m_customCallback.m_bCallbackInProcess == true ){

                //
                //  Nous sommes entrain d'executer un callback donc envoyons l'erreur a l'application externes ...
                //
                m_customCallback.forward(m_customCallback.m_callbacktag.onerror, publishdata);
                m_customCallback.log("customCallbackClass.onError> External callback execution failed on record id " + publishdata.recordid + " and project id " + publishdata.projectid + "-- " + userdata.errormsg, true);
            }
        }
        catch (e) {

        }

        m_customCallback.ResetInternalData();
        return;
    }


    this.onProjectSelection = function (userdata) {
        m_customCallback.log("customCallbackClass.onProjectSelection> The agent is on the selection page. It is time to reset internal variable to start with a clean object ...", false );
        m_customCallback.ResetInternalData();
    }

    //
    //  This method is called by voxco.agent when the agent is dialing a phone number . When received, if the external application 
    //  subscribes to ondial  event , it will be forwarded m_customCallback.notify() method
    //  
    //
    //  If the external application is interested to it , he needs to call the method 
    //
    //      1) getCallbackObject()
    //      2) subscribe() 
    //


    this.onDial = function (userdata) {

        m_customCallback.log("customCallbackClass.onDial> the agent is dialing...",false );

        var publishdata = m_customCallback.createUserData();
        m_customCallback.forward(m_customCallback.m_callbacktag.ondial, publishdata);
    }

    this.onInterview = function (userdata) {

        m_customCallback.log("customCallbackClass.onInterview> the agent is in interview...", false );
        m_customCallback.m_bOnCall = true;

        var publishdata = m_customCallback.createUserData();

        m_customCallback.forward(m_customCallback.m_callbacktag.onInterview, publishdata);
        return;
    }
  

    //
    //  This method is called by voxco.agent when the agent is connected with the respondent. When received, if the external application 
    //  subscribes to oncall  event , it will be forwarded m_customCallback.notify() method
    //  
    //
    //  If the external application is interested to it , he needs to call the method 
    //
    //      1) getCallbackObject()
    //      2) subscribe() 
    //


    this.onCall = function (userdata) {

        m_customCallback.m_bOnCall  = true;
        m_customCallback.m_PublishUserData.recordid  = m_customCallback.m_CallInfo.Get("recordid");
        m_customCallback.m_PublishUserData.projectid = m_customCallback.m_CallInfo.Get("projectid");

        var publishdata = m_customCallback.createUserData();
       
        m_customCallback.log("customCallbackClass.onCall> the agent is now oncall...", false );
        m_customCallback.forward(m_customCallback.m_callbacktag.oncall, publishdata);
    }


    //
    //  if the external application subscribe to voxco.agent event , this method notify it ..
    //
    //  event:
    //      ondial ...      the agent is currently dial record 
    //      onstatechane    the agent state has change ( Connected , Idle , Wrap Up ,Dialing... )
    //      oncall          the agent is doing an interview.
    //      oncomplete      the interview is completed.
    //

    this.forward = function (tag, userdata) {

        try{
            if (m_customCallback.m_ExternalNotifier != null) {
                if (m_customCallback.m_ExternalNotifier[tag] != undefined && m_customCallback.m_ExternalNotifier[tag] != null) {

                    m_customCallback.log("customCallbackClass.forward> trying to forward event notification " + tag + " to external application...", false );
                    m_customCallback.m_ExternalNotifier[tag].apply(userdata);

                }
            }
        }
        catch (e) {
            m_customCallback.log("customCallbackClass.forward> Caught an exception. Fail to notify the external application ... error " + e.message , true);
       
        }

    }


    this.ResetInternalData = function () {

        m_customCallback.m_PublishUserData.recordid = "";
        m_customCallback.m_PublishUserData.projectid = "";
        m_customCallback.m_bOnCall = false;
        m_customCallback.m_bCallbackInProcess = false;

        m_customCallback.log("customCallbackClass.ResetInternalData> Reset internal data....",false );
        return;
    }
    //
    //  This method if for internal use only. When the interview is done , the system need to log the agent back in the
    //  cati server. 
    //
    //

    this.onInterviewComplete = function (userdata) {



        m_customCallback.log("customCallbackClass.onInterviewComplete> the agent has completed his interview...", false );

        var publishdata = m_customCallback.createUserData();
        m_customCallback.forward(m_customCallback.m_callbacktag.oncomplete, publishdata);

        m_customCallback.m_PublishUserData.recordid = 0;
        m_customCallback.m_PublishUserData.projectid = 0;
        m_customCallback.m_bOnCall = false;

        if (m_customCallback.m_bCallbackInProcess == false)
            return;

    
        m_customCallback.m_bCallbackInProcess = false;
     
        //
        //  This request will log the agent back in in the original project. When the system execute a call back , we create a temporally interview with IACTION-19
        //
        var guid        = AgentAssignment.getSessionGuid();
        var cati        = AgentAssignment.getCatiId();
        var url         = m_customCallback.m_BaseUrl + '?IACTION=18&INTMODE=1' + '&imode=3' + "&project=" + cati + "&sessionguid=" + guid  ;
     
        m_customCallback.log("customCallbackClass.onInterviewComplete> the agent interview is now done. Sending request " + url, false);
        setTimeout("setIntWebUrl('" + url + "');", 1);
        return;
    }


    this.log = function (message, bError) {

        try {

            console.log(message);
            if (bError == true )
                m_customCallback.m_CloseSentinel.Logger._error(message);
            else
                m_customCallback.m_CloseSentinel.Logger._debug(message);
        }
        catch ( e ){
        }
    }

} ;

//
//  This function must be call by the external callback tools to create the java script obkect instance
//

var gCustomCallBackClass ;

function createCustomCallback() {

    //
    //  The object will instantiate only once...
    //
    if (gCustomCallBackClass == undefined || gCustomCallBackClass == null) {

        gCustomCallBackClass = new customCallbackClass();
        gCustomCallBackClass.Init();

    }

   
    return gCustomCallBackClass;
}